;*********************************************************************
; Filename:    	18F14K22_LCD_2wire_64MHz.ASM
; Date:        	2023.05.13
; Author:   	   Ottmar
; Software:  	   MPLAB 8.92 
; Programmer	   Pickit3
; File Version:   0
;---------------------------------------------------------------------
; Files Required: P18F14K22.INC
;                 Datenblatt DS40001365F
;                 HD44780_2Wire_PIC18F.INC
;---------------------------------------------------------------------
; Hardware:       PIC18F14K22
;                 IntOsc 4/64MHz
;                 LCD 2x16 HD44780
;                 2-Wire-Interface
;
; Pinbelegung:    PORTA
;                 RA3 (04) ICSP MCLRE/Vpp
;                 RA1 (18)	ICSP_PGC <- R1k2 -> LCD_CLOCK
;                 RA0 (19)	ICSP_PGD <- R1k2 -> LCD_DATA
;    		         Vdd (01) <-  C=100n -> Vss
;                 Vss (20)
;
;                 PORTB n.c.
;                 PORTC n.c.
;---------------------------------------------------------------------
; PROJECT
; Adaptation of the code in the file HD44780_2Wire_PIC18F.INC for
; output in the LCD at fosc max 64MHz (fosc/4=16MHz)
; Control of fosc(INTOSC) in the high priority ISR by measuring the
; blinking frequency of the LED at PORTC,RC0. ISR calls every 5000wc
; (wc=working cycle)          
;                 fosc(INTOSC) = f_RC0 * 40.000
;---------------------------------------------------------------------
; INTOSC Initialization:
;        CONFIG FOSC = IRC       ;Internal RC oscillator enabled
;        CONFIG PLLEN = OFF      ;PLL unde software control (OSCTUNE)
;        movlw b'01110000'       ;INTOSC f=8MHz (-> 'main:')
;        movwf OSCCON
;        bsf   OSCTUNE,PLLEN     ;4xPLL enabled
;*********************************************************************
;--PROCESSOR DECLARATION
   LIST      P=PIC18F14K22          ; list directive to define processor
   #INCLUDE <P18F14K22.INC>         ; processor specific variable definitions
; --------------------------------------------------------------------
;--SUPPRESSED WARNINGS:
   ERRORLEVEL -302 ;"Register in operand not in bank 0. Ensure .."
   ERRORLEVEL -207 ;"Found label after column 1."
   ;
;--CONFIG-SETUP
   CONFIG FOSC = IRC       ;Internal RC oscillator
   CONFIG PLLEN = OFF      ;
   ;                       ;OSCTUNE,PLLEN =0/1 fosc*1/*4
   CONFIG PCLKEN = OFF     ;Primary clock is under software control
   CONFIG FCMEN = OFF      ;Fail-Safe Clock Monitor disabled
   CONFIG IESO = OFF       ;Oscillator Switchover mode disabled
   CONFIG PWRTEN = ON      ;Power Up Timer enabled
   CONFIG LVP = OFF        ;Single-Supply ICSP disabled
   CONFIG WDTEN = OFF      ;Watchdog disabled
;*********************************************************************
;--VARIABLE DEFINITIONS
   CBLOCK 0x60 ; Sample GPR variable register allocations
      LcdData              ;Lcd_Init HD44780_2Wire.INC
      LcdBit               ;Bitzhler
      LcdFlags             ;Ablaufsteuerung Daten/Instruktionen
      d1,d2,d3,d4,d5       ;auxiliary variables
      varAscii             ;Asciicode0-9 to display inLCD
   ENDC
;*********************************************************************
;  LABELS & CONSTANTS
;*********************************************************************
;--LCD-PORT 2 Wire Interface
   LCD_PORT    EQU   PORTA
   LCD_LAT     EQU   LATA
   LCD_TRIS    EQU   TRISA
   LCD_ANSEL   EQU   ANSEL
   ;
   LCDCLK      EQU   RA1         ;(13) LCD_CLOCK ICSPCLK
   LCDDAT      EQU   RA0         ;(12) LCD_DATA  ICSPDAT
;*********************************************************************
;  LCD-PROPERTIES (adapt here the LCD-type)
;*********************************************************************
;   LCD_TYPE       EQU 1       ;=1 LCD 2x8 and 2x16
;   LCD_TYPE       EQU 2       ;=2=LCD 4x16
   LCD_TYPE       EQU 3       ;=3=LCD 4x20
   ;
   IF LCD_TYPE == 1           ;Uncomment LCD_DIGITS 2x8 OR 2x16 !!!
      LCD_LINES   EQU .2      ;LCD 2x8 * 2x16
      LCD_DIGITS  EQU .8      ;LCD 2x8      
;      LCD_DIGITS  EQU .16     ;LCD 2x16
   ENDIF
;-------------------------------------
;  NO CHANGES AFTER THIS LINE ALLOWED!
;-------------------------------------
   LINE1       EQU   0x00        ;all LCDs
   LINE2       EQU   0x40        ;"   "
   ;
   IF LCD_TYPE==2
      LINE3       EQU   0x10     ;LCDs 4x16 only
      LINE4       EQU   0x50     ;"    "    "
      LCD_LINES   EQU   .4       ;Lines
      LCD_DIGITS  EQU   .16      ;digits/line
   ENDIF
   ;
   IF LCD_TYPE==3
      LINE3       EQU   0x14     ;LCDs 4x20 only
      LINE4       EQU   0x54     ;"    "    "
      LCD_LINES   EQU   .4
      LCD_DIGITS  EQU   .20      ;digits/line
   ENDIF
   ;
   #DEFINE LCD_DATA LCD_LAT,LCDDAT ;Strobe Data  (H->L -> Enable)
   #DEFINE LCD_CLK  LCD_LAT,LCDCLK ;Strobe Clock (H->L)
   #DEFINE LCD_RS   LcdFlags,7     ;0/1 Data-Mode/Instruction-Mode
   #DEFINE NIBBLE   LcdFlags,6     ;1/0 send Upper/Lower Nibble to LCD
   ;
   SET_DDRAM_ADDR EQU   0x80       ;Function "SET DDRAM-ADDRESS"
   SET_CGRAM_ADDR EQU   0x40       ;"Set CGRAM Address" b'01000000
   ;
;*********************************************************************
;--RESET VECTOR                     ;Programm starts here
RES_VECT  ORG     0x0000            ;processor reset vector
          GOTO    init              ;initialize Ports and Modules
; --------------------------------------------------------------------
;--HIGH PRIORITY INTERRUPT VECTOR
ISRH  ORG     0x0008
      GOTO    high_isr
; --------------------------------------------------------------------
;--LOW PRIORITY INTERRUPT VECTOR
ISRL  ORG     0x0018
      RETFIE                        ;GOTO    low_isr
;*********************************************************************
init:
;--LCD_PORT PORTA
   clrf     LCD_PORT
   clrf     LCD_LAT
   clrf     LCD_TRIS
   clrf     LCD_ANSEL
   ;
;--PORTC
   clrf     PORTC
   clrf     LATC
   bcf      TRISC,RC0,  ;set RC0(16) as output (blinking LED)
   ;
;--T0CON: TIMER0 CONTROL REGISTER                           DS.91
;  8Bit-Timer, Int.Osc. is clock source, Prescaler 32:1
   movlw    b'01000100'
   movwf    T0CON
   ;
;--INTOSC INITIALIZATION                                       DS.19
;  CONFIG FOSC   = IRC PLLEN = ON necessary! in config setup!
  movlw b'01110000' ;= 16MHz  *4PLL = 64MHz
;  movlw b'01100000' ;= 8 MHz  *4PLL = 32MHz   
;  movlw b'01010000' ;= 4 MHz  *1
   movwf    OSCCON                                                ;DS.17
   bsf      OSCTUNE,PLLEN     ;b6=1 HFINTOSC *4 only 8 MHz&16 MHz! DS.19
;***************************
;  DON'T FORGET TO SET FOSC!
;***************************
 ; Xtal frequency, used to calculate multiplier in delays
;   FOSC        EQU    d'4'      ;actual fosc(MHz)
   FOSC        EQU    d'64'      ;actual fosc(MHz)   
   FOSC_MULT   EQU    FOSC/d'4'  ;4 clockx fosc = 1 wc
   ;
;--INTCON2: INTERRUPT CONTROL 2 REGISTER HIGH PRIORITY INTER.  DS.60ff
;  b2=1     TMR0 Overflow Interrupt HIGH PRIORITY
   movlw    b'00000100'
   movwf    INTCON2
   ;
;--INTCON: INTERRUPT CONTROL REGISTER
;--INTCON: INTERRUPT CONTROL REGISTER
   ;                          ;TMR0 Overflow HIGH Priority Interrupt
	bsf		INTCON,GIEH			;b7=1 enable  HIGH Priority Interr.
   bcf      INTCON,GIEL       ;b6=0 disable LOW  "
	bsf		INTCON,T0IE			;b5=1 TMR0 overflow interr. enabled
	bcf		INTCON,T0IF		   ;b2=0 TMR0-Ueberlauf ist nicht erfolgt
   ;
   bsf      T0CON,TMR0ON      ;b7=1 TMR0 enabled (8bit-timer)  DS.91
   ;
;*********************************************************************
; MAIN PROGRAM
;*********************************************************************
main:
   #IFNDEF  __DEBUG        ;avoid LCD-Init in Debug-Mode
      CALL  LCD_initialization
   #ENDIF
   ;
main_start_ascii:   
   movlw    .47            ;Ascii '/'
   movwf    varAscii
   ;
main_loop:
   CALL     Lcd_Ready      ;LCD-Test: "LCD 2Wire ready!
   movlw    LINE2          ;Set Cursor to Line 4, Digit 0
   CALL     OutDDRAM_Addr  ;send instruction to LCD
   incf     varAscii,f     ;Ascii 0-9
   movf     varAscii,w
   CALL     OutLcd_Data    ;display 0-9 in LCD
   movlw    1*FOSC_MULT    ;show text + Ascii for 2s
   CALL     Delay1000ms
   ;
   CALL     Lcd_Clear      ;show empty display during 2s
   movlw    1*FOSC_MULT
   CALL     Delay1000ms
   ;
   movlw    "9"            ;after "9" start again with "0"
   xorwf    varAscii,w
   btfsc    STATUS,Z       ;Z=1? Then varAscii=9
   GOTO     main_start_ascii     ;reset varAscii
   ;               
main_end:
   GOTO     main_loop
;*********************************************************************
;  SUBROUTINES
;*********************************************************************
;--HIGH PRIORITY INTERRUPT SERVICE ROUTINE
;  Intervall is 5000wc
;  fosc=f_RC0 *40.000
high_isr:                  ;Insert High Priority ISR Here   (5wc)
	movlw	   .100           ;Preset value TMR0
	movwf	   TMR0           ;Preset Timer0
  	bcf 	   INTCON,T0IF    ;b2=0 clear TMR0 overflow flag
  	;
  	BTG      LATC,RC0       ;Toggle LED
  	RETFIE   FAST
;*********************************************************************
LCD_initialization:
;initialize LCD as described in 'LABELS & CONSTANTS"
;send "LCD Ready for YOU" to the LCD
      CALL     Lcd_Init       ;initialize the LCD
;      CALL     Lcd_Ready      ;LCD-Test: "LCD 2Wire ready!
;      movlw    .10*FOSC_MULT  ;value to delay 10x100ms
;      CALL     Delay100ms     ;show LCD-Test for estimated delaytime
      CALL    Lcd_Clear       ;clear display
   RETURN  
;*********************************************************************
   #INCLUDE <18F14K22_LCD_2wire_64MHz_Test.INC>
;*********************************************************************
   END